#ifndef zcommH
#define zcommH

#include <windows.h>
#include <dsgnintf.hpp>

#define	WM_COMM		WM_USER+0

// states

#define ZC_CLOSED	1
#define ZC_OPEN		2
#define ZC_READ		3
#define ZC_WRITE	4

// errors

#define ZC_ERROR_THREAD		1

#define ASCII_XON       0x11
#define ASCII_XOFF      0x13

enum TStopBits{ stop1, stop1x5, stop2 };
enum TParity { no_parity, odd_parity, even_parity, mark_parity, space_parity };
enum TDataBits { databits4, databits5, databits6, databits7, databits8 };

typedef void __fastcall (__closure *TCommErrorEvent)(System::TObject *Sender,
						int	error, AnsiString errorstr);

class TZComm : public TComponent
{
private:

TNotifyEvent 	FOnDataAvailable;
TCommErrorEvent FOnErrorOccurred;

TThread		*FCommWatchThread;
HWND		FHWnd;
HANDLE		FComHandle;
DWORD		FThreadID;
HANDLE		FThreadHandle;
OVERLAPPED  FOSRead;
OVERLAPPED  FOSWrite;
HANDLE		FPostEvent;

AnsiString  FText;

AnsiString	FPort;
unsigned long FBaudRate;
TParity		FParity;
TDataBits   FDataBits;
TStopBits   FStopBits;
unsigned long FBufferSize;
Boolean		FEnableParity;
Boolean 	FCTSFlow;
Boolean 	FDSRFlow;
Boolean		FDSRSensitive;
Boolean 	FTXResume;
Boolean		FOuputX;
Boolean		FInputX;
Boolean		FErrorReplace;
Boolean		FDiscardNULL;
Boolean		FAbortOnError;
unsigned long FInputQ;
unsigned long FOutputQ;
unsigned int FXOnLimit;
unsigned int FXOffLimit;
char		FXOnChar;
char		FXOffChar;
char		FErrorChar;
unsigned long FTOReadInterval;
unsigned long FTOReadMultiplier;
unsigned long FTOReadConstant;
unsigned long FTOWriteMultiplier;
unsigned long FTOWriteConstant;

int			FState;
BOOL		FConnected;
AnsiString	FVersion;
AnsiString	FXVersion;

BOOL __fastcall TZComm::SetFlowCtl(int flow);
void __fastcall TZComm::SetText(AnsiString as);
AnsiString __fastcall TZComm::GetText();

protected:

void __fastcall TZComm::WindowMessageProc(TMessage& msg);
BOOL __fastcall TZComm::MessageCOMM(TMessage& msg);

public:
	virtual __fastcall TZComm(TComponent* Owner);
	virtual __fastcall TZComm::~TZComm();

	BOOL __fastcall TZComm::OpenConnection();
	BOOL __fastcall TZComm::SetConnection();
	BOOL __fastcall TZComm::CloseConnection();
	BOOL __fastcall TZComm::WriteComm(unsigned char *buffer, long length);
	BOOL __fastcall TZComm::WriteCommByte(unsigned char c);
	long __fastcall TZComm::ReadComm(unsigned char *buffer, long max_length);
	BOOL __fastcall TZComm::EscapeComm(unsigned long param);
	BOOL __fastcall TZComm::SetTimeouts();
	BOOL __fastcall TZComm::GetTimeouts();
    BOOL __fastcall TZComm::PurgeCommPort(unsigned long);

__published:

	__property AnsiString Text = {read=GetText, write=SetText};
  	__property AnsiString Port = {read=FPort, write=FPort};
  	__property unsigned long BaudRate = {read=FBaudRate, write=FBaudRate, default = 9600};
  	__property TParity Parity = {read=FParity, write=FParity};
  	__property TDataBits DataBits = {read=FDataBits, write=FDataBits, default = 4};
  	__property TStopBits StopBits = {read=FStopBits, write=FStopBits};
	__property unsigned long MaxReadLength = {read=FBufferSize, write=FBufferSize, default = 8192};
    __property unsigned long InputQueueSize = {read=FInputQ, write=FInputQ, default = 8192 };
    __property unsigned long OutputQueueSize = {read=FOutputQ, write=FOutputQ, default = 8192 };
	__property unsigned int	XOnLimit = {read = FXOnLimit, write = FXOnLimit, default = 150 };
	__property unsigned int	XOffLimit = {read = FXOffLimit, write = FXOffLimit, default = 150};

	__property Boolean 	CTSFlowCtl = {read = FCTSFlow, write=FCTSFlow };
	__property Boolean 	DSRFlowCtl 	= {read = FDSRFlow, write=FDSRFlow };
	__property Boolean	EnableParity = {read = FEnableParity, write = FEnableParity, default = TRUE };
	__property Boolean	DSRSensitive = {read = FDSRSensitive, write=FDSRSensitive, default = FALSE };
	__property Boolean 	TXResume = {read = FTXResume, write=FTXResume, default = FALSE };
	__property Boolean	XOuputFlowCtl = {read = FOuputX, write=FOuputX , default = TRUE };
	__property Boolean	XInputFlowCtl = {read = FInputX, write=FInputX, default = TRUE };
	__property Boolean	ErrorReplace = {read = FErrorReplace, write=FErrorReplace };
	__property Boolean	DiscardNULL = {read = FDiscardNULL, write=FDiscardNULL, default = FALSE };
	__property Boolean	AbortOnError = {read = FAbortOnError, write=FAbortOnError, default = TRUE };
	__property char		ErrorChar = {read = FErrorChar, write = FErrorChar };
	__property char		XOnChar = {read = FXOnChar, write = FXOnChar, default = ASCII_XON };
	__property char		XOffChar = {read = FXOffChar, write = FXOffChar, default = ASCII_XOFF };

	__property unsigned long TimeoutReadInterval = { read = FTOReadInterval, write = FTOReadInterval,default = 0xFFFFFFFF};
	__property unsigned long TimeoutReadMultiplier = { read = FTOReadMultiplier , write = FTOReadMultiplier, default = 0 };
	__property unsigned long TimeoutReadConstant = { read = FTOReadConstant, write = FTOReadConstant, default = 0};
	__property unsigned long TimeoutWriteMultiplier = { read = FTOWriteMultiplier , write = FTOWriteMultiplier, default = 0};
	__property unsigned long TimeoutWriteConstant = { read = FTOWriteConstant, write = FTOWriteConstant, default = 5000};

// readonly

	__property int State = {read=FState};
	__property AnsiString Version = {read=FVersion, write = FXVersion};
  	__property BOOL Connected = {read=FConnected};

	__property TCommErrorEvent OnErrorOccurred =
				{read=FOnErrorOccurred, write=FOnErrorOccurred};

	__property TNotifyEvent OnDataAvailable =
				{read=FOnDataAvailable, write=FOnDataAvailable};

};

class TCommThread : public TThread
{
private:
HANDLE		FPostEvent;
HANDLE		FComHandle;
HWND		FHWnd;
protected:
	void __fastcall Execute();

public:

	__fastcall TCommThread(bool CreateSuspended, TZComm *ZComm,
			HANDLE aComHandle, HWND aHWnd);

    TZComm *ZComm;
};

#endif
